<?php
/**
 * Get Social Shares class
 *
 * @author  Bishoy A. <hi@bishoy.me>
 */

class PsscShareCount {
	/**
	 * URL to check it's shares
	 * @var string
	 */
	private $url;

	/**
	 * Timeout (Maximum time for CURL request)
	 * @var integer
	 */
	private $timeout;

	/**
	 * The constructor
	 * @param string  $url
	 * @param integer $timeout
	 */
	public function __construct( $url, $timeout = 10 ) {
		$this->url     = rawurlencode( $url );
		$this->raw_url = $url;
		$this->timeout = $timeout;
	}

	/**
	 * Get Twitter Tweets
	 * @return integer Tweets count
	 */
	public function pssc_twitter() { 
		$settings = array(
		    'oauth_access_token' => ot_get_option('twitter_bar_accesstoken'),
		    'oauth_access_token_secret' => ot_get_option('twitter_bar_accesstokensecret'),
		    'consumer_key' => ot_get_option('twitter_bar_consumerkey'),
		    'consumer_secret' => ot_get_option('twitter_bar_consumersecret')
		);
		$url = 'https://api.twitter.com/1.1/search/tweets.json';
		$getfield = '?q='.$this->raw_url.'&result_type=recent';
		$twitter = new thb_TwitterAPIExchange($settings);
		$twitter_data = json_decode($twitter->setGetfield($getfield)
		             ->buildOauth($url, 'GET')
		             ->performRequest());
		
		$count = max(sizeof($twitter_data->statuses), 0);

		return $count;
	}

	/**
	 * Get Linked In Shares
	 * @return integer
	 */
	public function pssc_linkedin() { 
		$json_string = $this->file_get_contents_curl( "http://www.linkedin.com/countserv/count/share?url=$this->url&format=json" );
		$json = json_decode( $json_string, true );
		return isset( $json['count'] ) ? intval( $json['count'] ) : 0;
	}

	/**
	 * Get Facebook Shares
	 * @return integer
	 */
	public function pssc_facebook() {
		$return_data = wp_remote_get( 'http://api.facebook.com/restserver.php?method=links.getStats&format=json&urls='.$this->url );
		if ( is_wp_error( $return_data ) ) {
			echo $error_string = $return_data->get_error_message();
			return 0;
		}
		$return_data = wp_remote_retrieve_body( $return_data );
		$json = json_decode( $return_data, true );
		return isset( $json[0]['total_count'] ) ? intval( $json[0]['total_count'] ) : 0;
	}

	/**
	 * Get Goolge+ ones
	 * @return integer
	 */
	public function pssc_gplus() {
		$curl = curl_init();
		curl_setopt( $curl, CURLOPT_URL, 'https://clients6.google.com/rpc' );
		curl_setopt( $curl, CURLOPT_POST, true );
		curl_setopt( $curl, CURLOPT_SSL_VERIFYPEER, false );
		curl_setopt( $curl, CURLOPT_POSTFIELDS, '[{"method":"pos.plusones.get","id":"p","params":{"nolog":true,"id":"'.rawurldecode( $this->url ).'","source":"widget","userId":"@viewer","groupId":"@self"},"jsonrpc":"2.0","key":"p","apiVersion":"v1"}]');
		curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'Content-type: application/json' ) );
		$curl_results = curl_exec( $curl );
		curl_close( $curl );
		$json = json_decode( $curl_results, true );
		return isset( $json[0]['result']['metadata']['globalCounts']['count'] ) ? intval( $json[0]['result']['metadata']['globalCounts']['count'] ) : 0;
	}

	/**
	 * Get Stumble Views
	 * @return integer
	 */
	public function pssc_stumble() {
		$json_string = $this->file_get_contents_curl( 'http://www.stumbleupon.com/services/1.01/badge.getinfo?url='.$this->url );
		$json = json_decode( $json_string, true );
		return isset( $json['result']['views'] ) ? intval( $json['result']['views'] ) : 0;
	}

	/**
	 * Get Delicious shares
	 * @return integer
	 */
	public function pssc_delicious() {
		$json_string = $this->file_get_contents_curl( 'http://feeds.delicious.com/v2/json/urlinfo/data?url='.$this->url );
		$json = json_decode( $json_string, true );
		return isset( $json[0]['total_posts'] ) ? intval( $json[0]['total_posts'] ) : 0;
	}

	/**
	 * Get pinterest Pins
	 * @return integer
	 */
	public function pssc_pinterest() {
		$return_data = wp_remote_get( 'http://api.pinterest.com/v1/urls/count.json?url='.$this->url );
		
		if ( is_wp_error( $return_data ) ) {
			echo $error_string = $return_data->get_error_message();
			return 0;
		}
		$return_data = wp_remote_retrieve_body( $return_data );
		$json_string = preg_replace("/[^(]*\((.*)\)/", "$1", $return_data );
		$json = json_decode( $json_string, true );

		return isset( $json['count'] ) ? intval( $json['count'] ) : 0;
	}

	/**
	 * File Get Content by Curl
	 * @param  string $url
	 * @return mixed
	 */
	private function file_get_contents_curl( $url ) {
		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $url );
		curl_setopt( $ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT'] );
		curl_setopt( $ch, CURLOPT_FAILONERROR, 1 );
		curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1 );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER,1 );
		curl_setopt( $ch, CURLOPT_TIMEOUT, $this->timeout );
		curl_setopt( $ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4); 
		$cont = curl_exec( $ch );
		if ( curl_error( $ch ) )	{
			die( curl_error( $ch ) );
		}
		return $cont;
	}

	/**
	 * Get all counts
	 * @return integer total count
	 */
	public function pssc_all() {
		$count = 0;

		$tw = $this->pssc_twitter();
		$fb = $this->pssc_facebook();
		$gp = $this->pssc_gplus();
		$pi = $this->pssc_pinterest();

		$count = $tw + $fb + $gp + $pi;

		return $count;
	}
}