<?php 
	$vars = $wp_query->query_vars;
	$thb_shares = array_key_exists('thb_shares', $vars) ? $vars['thb_shares'] : false;	
	$thb_counts = array_key_exists('thb_counts', $vars) ? $vars['thb_counts'] : false;	
	$thb_imagesize = array_key_exists('thb_imagesize', $vars) ? $vars['thb_imagesize'] : 'thumbnail';	
	$thb_class = array_key_exists('thb_class', $vars) ? $vars['thb_class'] : false;	
	$figure_classes[] = 'figure';
	$figure_classes[] = $thb_counts ? 'count-image' : false;
	$figure_classes[] = $thb_class;
?>
<li itemscope itemtype="http://schema.org/Article" <?php post_class('post listing'); ?> role="article">
	<?php if (has_post_thumbnail()) { ?> 
	<a class="<?php echo implode(' ', $figure_classes); ?>" href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
		<?php if($thb_counts) { ?><span class="count"><?php echo esc_attr($thb_counts); ?></span><?php } ?>
		<?php the_post_thumbnail($thb_imagesize); ?>
	</a>
	<?php } ?>
	<div class="listing_content">
		<?php do_action('thb_categories'); ?>
		<header class="post-title entry-header">
			<?php the_title('<h6 class="entry-title" itemprop="name headline"><a href="'.get_permalink().'" title="'.the_title_attribute("echo=0").'">', '</a></h6>'); ?>
		</header>
		<?php if ($thb_shares) { get_template_part( 'inc/templates/postbits/post-just-shares' ); } ?>
		<?php do_action('thb_PostMeta'); ?>
	</div>
</li>